unit MainUnit;

//  
//      TTabControl,
//         
//  .     Tab ( TStrimgs).
//      TabIndex, 
//      .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, ImgList;

type
  TForm1 = class(TForm)
    TabControl1: TTabControl;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    CBoxTabIndex: TComboBox;
    Button1Panel1: TButton;
    Button2Panel1: TButton;
    Button1Panel2: TButton;
    Button1Panel3: TButton;
    CBoxStyle: TComboBox;
    CBoxTabPosition: TComboBox;
    ImageList1: TImageList;
    LabelTitle: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Bevel1: TBevel;
    Label8: TLabel;
    ButtonExit: TButton;
    procedure TabControl1Change(Sender: TObject);
    procedure CBoxTabIndexChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CBoxStyleChange(Sender: TObject);
    procedure CBoxTabPositionChange(Sender: TObject);
    //       
    procedure ShowButton(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
  private
    { Private declarations }
    procedure InitPanelsAndTabControl();
    procedure ShowPanel(RqInd : integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// -------------------------------------------------------------------
//  ,   TabControl1
// -------------------------------------------------------------------

//   ,    TabControl1
procedure TForm1.InitPanelsAndTabControl();
begin
  Panel1.Visible := False;
  Panel2.Visible := False;
  Panel3.Visible := False;
  //   - 
  TabControl1.TabIndex := 3;
  Panel4.Visible := True;
  CBoxTabIndex.ItemIndex := TabControl1.TabIndex;
end;

//  ,    TabControl1
procedure TForm1.ShowPanel(RqInd : integer);
begin
  //   
  Panel1.Visible := False;
  Panel2.Visible := False;
  Panel3.Visible := False;
  Panel4.Visible := False;
  //   
  case RqInd of
   0: Panel1.Visible:=true;
   1: Panel2.Visible:=true;
   2: Panel3.Visible:=true;
   3: Panel4.Visible:=true;
 end;
end;

//     /  TabControl1
procedure TForm1.TabControl1Change(Sender: TObject);
begin
  ShowPanel(TabControl1.TabIndex);
  CBoxTabIndex.ItemIndex := TabControl1.TabIndex;
end;

//    TabControl1
procedure TForm1.FormShow(Sender: TObject);
begin
  InitPanelsAndTabControl();
end;

//     TabControl1
procedure TForm1.CBoxTabIndexChange(Sender: TObject);
begin
   //    TabControl1
   TabControl1.TabIndex := CBoxTabIndex.ItemIndex;
   //   
   ShowPanel(TabControl1.TabIndex);
end;

// -------------------------------------------------------------------
//      TabControl1
// -------------------------------------------------------------------

//     
procedure TForm1.CBoxStyleChange(Sender: TObject);
begin
  case CBoxStyle.ItemIndex of
  0 : TabControl1.Style := tsTabs;
  1 : TabControl1.Style := tsButtons;
  2 : TabControl1.Style := tsFlatButtons;
  end;
end;

//      TabControl1
// (    TabControl1.Style = tsTabs )
procedure TForm1.CBoxTabPositionChange(Sender: TObject);
begin
  case CBoxTabPosition.ItemIndex of
  0 : TabControl1.TabPosition := tpTop;
  1 : TabControl1.TabPosition := tpBottom;
  2 : TabControl1.TabPosition := tpLeft;
  3 : TabControl1.TabPosition := tpRight;
  end;
end;

// -------------------------------------------------------------------
//    ,   
// -------------------------------------------------------------------

//       
procedure TForm1.ShowButton(Sender: TObject);
begin
  if  Sender is TButton
  then begin
    with Sender as TButton
    do begin
      ShowMessage(Caption);
    end;
  end;
end;

//  
procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

end.
